#include <set>
#include <cmath>
#include <vector>
#include <utility>
#include <iostream>
#include <unordered_map>

class Voting {
private:
    size_t m_Count;
    std::set<int> m_PresentVotes;
    std::unordered_map<int, int> m_VoteArity;
public:
    Voting(size_t, std::istream&);
public:
    void Add(int);
public:
    friend class VotingCheatEngine;
};
class VotingCheatEngine {
private:
    std::vector<int> m_VotesSorted;
    std::unordered_map<int, std::pair<int, int>> m_VoteRanges;
public:
    VotingCheatEngine(const Voting&);
private:
    int ConvergeIndex(int) const;
public:
    int Cheat(int) const;
    size_t VoteCount() const;
    size_t MidpointIndex() const;
};

void OptimiseIO() {
    std::ios_base::sync_with_stdio(false);
    std::cout.tie(0);
    std::cerr.tie(0);
    std::cin.tie(0);
}

int main() {
    OptimiseIO();
    size_t n;
    size_t q;
    std::cin >> n >> q;
    Voting voting(n, std::cin);
    std::vector<int> markosTargets(q);
    VotingCheatEngine markosEngine(voting);
    while (q) {
        std::cin >> markosTargets[markosTargets.size() - q--];
    }
    for (auto& target : markosTargets) {
       std::cout << markosEngine.Cheat(target) << std::endl;
    }
    return 0;
}


// Voting: Constructors
Voting::Voting(size_t count, std::istream& in)
: m_Count(0) {
    while (count--) {
        int vote;
        in >> vote;
        Add(vote);
    }
}

// Voting: Public Methods
void Voting::Add(int vote) {
    if (m_VoteArity.find(vote) == m_VoteArity.end()) {
        m_PresentVotes.insert(vote);
        m_VoteArity.insert({vote, 0});
    }
    ++m_VoteArity[vote];
    ++m_Count;
}


// VotingCheatEngine: Constructors
VotingCheatEngine::VotingCheatEngine(const Voting& referenceVoting) 
: m_VotesSorted(referenceVoting.m_PresentVotes.begin(), referenceVoting.m_PresentVotes.end()) {
    int prefix = 0;
    for (int& vote : m_VotesSorted) {
        m_VoteRanges.insert({ vote, { prefix, prefix + referenceVoting.m_VoteArity.at(vote) } });
        prefix += referenceVoting.m_VoteArity.at(vote);
    }
}

// VotingCheatEngine: Private Methods
int VotingCheatEngine::ConvergeIndex(int target) const {
    int up = m_VotesSorted.size() - 1;
    int low = 0;
    while (low <= up) {
        int midpoint = (up + low) / 2;
        if (m_VotesSorted[midpoint] == target) {
            return midpoint;
        }
        if (m_VotesSorted[midpoint] < target) {
            low = midpoint + 1;
            continue;;
        }
        up = midpoint - 1;
    }
    return low;
}
// VotingCheatEngine: Public Methods
size_t VotingCheatEngine::VoteCount() const {
    return m_VoteRanges.at(m_VotesSorted.back()).second;
}
size_t VotingCheatEngine::MidpointIndex() const {
    return VoteCount() / 2;
}
int VotingCheatEngine::Cheat(int target) const {
    int midpointIndex = MidpointIndex();
    int targetIndex = ConvergeIndex(target);
    if (targetIndex == m_VotesSorted.size()) {
        return 2 * midpointIndex + (VoteCount() % 2);
    }
    int atTargetIndex = m_VotesSorted[targetIndex];
    bool voteExists = atTargetIndex == target;
    if (voteExists) {
        if (m_VoteRanges.at(target).first <= midpointIndex && midpointIndex < m_VoteRanges.at(target).second) {
            return 0;
        }
        if (m_VoteRanges.at(target).first > midpointIndex) {
            return 2 * (m_VoteRanges.at(target).first - midpointIndex) - (VoteCount() % 2);
        }
        if (midpointIndex >= m_VoteRanges.at(target).second) {
            return (VoteCount() % 2) + 2 * (midpointIndex - m_VoteRanges.at(target).second) + 1;
        }
    }
    if (m_VoteRanges.at(atTargetIndex).first > midpointIndex) {
        return 2 * (m_VoteRanges.at(atTargetIndex).first - midpointIndex) - (VoteCount() % 2);
    }
    if (midpointIndex >= m_VoteRanges.at(atTargetIndex).first) {
        return (VoteCount() % 2) + 2 * (midpointIndex - m_VoteRanges.at(atTargetIndex).first) + 1;
    }
    throw std::logic_error("How?...");
}